/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.memory;

import emulator.hardware.bus.Bus;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.UnmappedMemoryException;
import emulator.util.ByteArrayWrapper;
import java.util.Arrays;

public class MemoryBlock
extends ByteArrayWrapper
implements Bus {
    public MemoryBlock(int size) {
        super(new byte[size]);
        Arrays.fill(this.getData(), (byte)0);
    }

    @Override
    public int read(int address) throws UnmappedMemoryException, BusWatchException {
        return this.getData()[address] & 0xFF;
    }

    @Override
    public void write(int address, int data) throws UnmappedMemoryException, BusWatchException {
        this.getData()[address] = (byte)(data & 0xFF);
    }
}

